#include <GUIConstants.au3>
#include <Video.au3>
;

Global $hVideo, $tAlias, $iLength = 0

$hGUI = GUICreate("Test Video Player", 340, 280)
$hPlay = GUICtrlCreateButton("Play", 10, 255, 60, 20)
$hPause = GUICtrlCreateButton("Pause", 75, 255, 60, 20)
$hLoad = GUICtrlCreateButton("Load", 140, 255, 60, 20)
$Position_Slider = GUICtrlCreateSlider(205, 255, 130, 20) ; slider to seek position
GUICtrlSetLimit(-1, 100)
GUISetState()

While 1
	Switch GUIGetMsg()
		Case $GUI_EVENT_CLOSE
			_Video_Close($hVideo)
			Exit
		Case $Position_Slider
			_SetSeek_Proc()
		Case $hPlay
			_Video_Play($hVideo)
			AdlibEnable("_CheckTimePos", 5000)
		Case $hPause
			_Video_Pause($hVideo)
			AdlibDisable()
		Case $hLoad
			$sFile = FileOpenDialog("Open Video", "", "All Files (*.*)", 1, "", $hGUI)
			
			If @error Then
				$iLength = 0
			Else
				$hVideo = _Video_Open($sFile, $hGUI, 10, 10, 320, 240)
				$iLength = _Video_Length($hVideo, 1)
				GUICtrlSetData($Position_Slider, 0)
				AdlibDisable()
			EndIf
	EndSwitch
WEnd

Func _CheckTimePos()
	Local $sTime = _Video_TimePos($hVideo)
	If Not @error Then GUICtrlSetTip($Position_Slider, $sTime)
EndFunc

Func _SetSeek_Proc()
	Local $iPos, $iTotalMs
	
	If $iLength > 0 Then
		_CheckTimePos()
		$iPos = GUICtrlRead($Position_Slider) / 100
		$iTotalMs = Int($iPos * $iLength)
		_Video_Seek($hVideo, $iTotalMs)
		_Video_Pause($hVideo)
		_Video_Play($hVideo)
	EndIf
EndFunc
